; Mains Timer

; revision. fixed repeated on and off signals in repeat on at and off at setting for times above 1:0. See in interrupt.

	ERRORLEVEL -302
	ERRORLEVEL -306

	list P=16F88
	#include p16f88.inc

;Program Configuration Register 1
		__CONFIG    _CONFIG1, _CP_OFF & _CCP1_RB3  & _DEBUG_OFF & _WRT_PROTECT_OFF & _CPD_OFF & _LVP_OFF & _BODEN_OFF & _MCLR_ON & _PWRTE_ON & _WDT_OFF & _XT_OSC

;Program Configuration Register 2
		__CONFIG    _CONFIG2, _IESO_OFF & _FCMEN_OFF


; Define variables at memory locations
EEPROM1			equ	H'00'	; clock correction storage
EEPROM2			equ H'01'	; On and Off IN goes to 0 or return to last setting so cycle repeats (ON pressed at power up to toggle selection)
EEPROM3			equ	H'02'	; On and Off AT daily or once only (OFF pressed at power up to toggle selection)
EEPROM4			equ	H'03'	; cycle mode ON/OFF IN or ON/OFF AT
EEPROM5			equ	H'04'	; backlighting

; Bank 0 RAM

SW_FLAG			equ H'20'	; switch debounce/delay
MODE			equ	H'21'	; count down timer or real time
BRIGHTNESS		equ	H'22'	; backlight brightness
STORE1			equ	H'23'	; delay counter
STORE2			equ	H'24'	; delay counter
REPEAT			equ	H'25'	; initialisation repeat
SECONDS_LAST	equ	H'26'	; seconds value last number for comparison for if changed
NEXT			equ	H'27'	; display value that can be set
SET_START		equ	H'28'	; set or start
DISP_CHNG		equ	H'29'	; display change flag
MSECS			equ	H'2A'	; milliseconds counter (25/second)
SW_DLY			equ	H'2B'	; switch delay flag
ROLL			equ	H'2C'	; backlight bargraph working display register
COUNT_DN		equ	H'2D'	; count down register for display clear
UP_DN			equ	H'2E'	; up/down brightness counting
CYCLE_MODE		equ	H'2F'	; mode of operation
BACK			equ	H'30'	; backlight written flag
POWER_TEST		equ	H'31'	; test for loss of power/backup supply
COLON_FLASH		equ	H'32'	; colon flash flag
BLACKOUT		equ	H'33'	; blackout flag
CORRECTION		equ	H'34'	; correction value for clock in ppm (0-+/-99), - slows clock, + speeds it up (in 1ppm steps)
HR_ON_IN		equ	H'35'	; hour on in counter
MIN_ON_IN		equ	H'36'	; minutes on in counter
HR_OFF_IN		equ	H'37'	; hour off in counter
MIN_OFF_IN		equ	H'38'	; minutes off in counter
HR_ON_AT		equ	H'39'	; hour on at counter
MIN_ON_AT		equ	H'3A'	; minutes on in counter
HR_OFF_AT		equ	H'3B'	; hour off at counter
MIN_OFF_AT		equ	H'3C'	; minutes off in counter
OFF_FLAG		equ	H'3D'	; off flag
ON_FLAG			equ	H'3E'	; on flag
SECONDS_RTC		equ	H'3F'	; RTC seconds
LAST			equ	H'40'	; last signal on or off
IN_SELECT		equ	H'41'	; on and off in selection
AT_SELECT		equ	H'42'	; on and off at selection
MIN_ON_IN_STORE	equ	H'43'	; store last ON_IN value at Start
HR_ON_IN_STORE	equ	H'44'	; store last ON_IN value at Start
MIN_OFF_IN_STORE equ H'45'	; store last OFF_IN value at Start
HR_OFF_IN_STORE	equ	H'46'	; store last ON_IN value at Start
CYC_DEL			equ	H'47'	; cycle counter for cycle switch
ROTATE			equ	H'48'	; rotate cycle symbol flag

; All Banks RAM

W_TMP			equ	H'70'	; storage of w before interrupt
STATUS_TMP		equ	H'71'	; status storage before interrupt
SECONDS			equ	H'72'	; seconds counter
MINUTES			equ	H'73'	; minutes RTC
HOURS			equ	H'74'	; hours RTC
BCD_0			equ	H'75'	; MS bcd value
BCD_1			equ	H'76'	; LS binary coded decimal value
BIN_0			equ	H'77'	; 8-bit binary value
TEMP			equ	H'78'	; data storage 
CNT_8			equ	H'79'	; counter in BCD routine
OUT1			equ	H'7A'	; ASCII byte
OUT2			equ	H'7B'	; ASCII byte
OUT3			equ	H'7C'	; ASCII byte
D_STO			equ	H'7D'	; data storage during LCD drive
LCD_STO			equ	H'7E'	; LCD data store during LCD data transfer


; preprogram EEPROM DATA 
	
 ORG    H'2100'
 DE		H'00' ; zero ppm : 01 is +1, FF is -1, 02 is +2, FE is -2 etc
 DE		H'00' ; standard on and off IN cycle once
 DE		H'00' ; standard on and off AT repeat cycle each day
 DE		H'00' ; ON/OFF IN mode
 DE		H'00' ; backlighting
		
	org	0
	goto	SETUP
	org	4
	goto	INTERRUPT

SETUP
	
	call	DELAY1

	movlw	B'00000000'
	movwf	PORTB		; 
	movwf	PORTA

	bsf		STATUS,RP0	; select memory bank 1

; set inputs/outputs
	movlw	B'00000111'	; comparators off
	movwf	CMCON
	movlw	B'00110100'	; port B outputs/ inputs set 
	movwf	TRISB		; port B data direction register
	movlw	B'11100000'	; outputs (0) and inputs (1)
	movwf	TRISA		; port A data direction register
	movlw	B'00000111'	; settings (pullups enabled TMR0/256)
	movwf	OPTION_REG
; analog/ digital inputs
	movlw	B'00000000'	; all digital inputs
	movwf	ANSEL
	bcf		STATUS,RP0	; select memory bank 0

; timer 1 
	movlw	B'00000001'	; timer 1 fosc/4 1:1 prescaler so overflow 25 times per second if TMR1H is preloaded
; to count down from D40000
	movwf	T1CON

; PWM
	bsf		STATUS,RP0	; select memory bank 1		
	movlw	H'0E'
	movwf	PR2			; PWM period register
	bcf		STATUS,RP0	; memory bank 0
	
; pwm set
	clrf	CCPR1L		; duty 0% Mosfet off
	bcf		CCP1CON,4
	bcf		CCP1CON,5	; clear 10-bits
	bsf		T2CON,2		; enable timer 2

	movlw	B'00001100'	; set PWM mode
	movwf	CCP1CON		; enable PWM operation
	
	movlw	H'F0'		; start up delay
	call	DELAYXX

; get clock correction value
	movlw	EEPROM1
	call	EEREAD
	movwf	CORRECTION
; ON and OFF IN option
	movlw	EEPROM2		; On and Off IN goes to 0 or return to last setting so cycle repeats (ON pressed at power up to toggle selection)
	call	EEREAD
	movwf	IN_SELECT	; on and off IN selection
; ON and OFF AT option
	movlw	EEPROM3		; On and Off AT daily or once only (OFF pressed at power up to toggle selection)
	call	EEREAD
	movwf	AT_SELECT	; on and off AT selection
; cycle mode
	movlw	EEPROM4		; On and Off AT daily or once only (OFF pressed at power up to toggle selection)
	call	EEREAD
	movwf	CYCLE_MODE	; Cycle mode bit 0 = clear ON/OFF IN, set = ON/OFF AT
; backlighting
	movlw	EEPROM5		; backlighting brightness
	call	EEREAD
	movwf	BRIGHTNESS
	movwf	CCPR1L

; initialise display for 4-bit operation

INIT_LC
	bcf		PORTB,7		; RS low
	bcf		PORTB,0		; DB7 low	
	movlw	B'00001000'	; DB6 DB4 low, DB5 high via RA3 to initialise module
	movwf	PORTA
	nop
	bsf		PORTA,1		; enable high
	nop
	bcf		PORTA,1
	nop
	bcf		PORTA,3

; now uses 4-bit coding
	call	DELAYms
	movlw	B'00101100'	; display function (4-bits, 2 lines, 5x10 dots)
	call	LOAD		; loads high byte then low byte is two separate operations
	call	DELAYms
	movlw	B'00001100'	; blinking off, cursor off
	call	LOAD
	call	DELAYms
	movlw	B'00000001'	; display clear
	call	LOAD
	movlw	H'30'		; delay 
	call	DELAYX		; 
	movlw	B'00000110'	; entry mode. cursor moves right, display not shifted
	call	LOAD

	call	CHARACTR_GEN; generate character for display

INIT_VAL

; initial conditions
	clrf	TMR1H 		;
	bsf		TMR1H,7		; set MS bit
	clrf	TMR1L		; timer 1 is the seconds counter rolling every 4s
	clrf	SECONDS_RTC	; Initialize timer counter seconds for RTC
	clrf	SECONDS		; Initialize seconds timer counter used for count down timers
	clrf	HR_ON_IN	; hour on in counter
	clrf	MIN_ON_IN	; minutes on in counter
	clrf	HR_OFF_IN	; hour off in counter
	clrf	MIN_OFF_IN	; minutes off in counter
	clrf	HR_ON_AT	; hour on at counter
	clrf	MIN_ON_AT	; minutes on at counter
	clrf	HR_OFF_AT	; hour off at counter
	clrf	MIN_OFF_AT	; minutes on at counter
	bsf		UP_DN,0		; down counting 
	clrf	OFF_FLAG	; off flag
	clrf	ON_FLAG		; on flag
	clrf	BACK		; backlight written flag
	clrf	NEXT		; display value that can be set
	clrf	SET_START	; set or start
	clrf	DISP_CHNG	; display change flag
	clrf	MSECS		; milliseconds counter 25/second
	clrf	SW_DLY		; switch delay flag
	clrf	MINUTES		; minutes RTC
	clrf	HOURS		; hours RTC
	clrf	COLON_FLASH
	clrf	LAST		; last signal on or off cleared as nil
	clrf	ROTATE		; cycle symbol change rate counter

; 0 is count down mode, 00000001 is real clock time mode, B00000010 is RTC 

; interrupts settings
	bsf		STATUS,RP0	; select memory bank 1
	bsf		PIE1,TMR1IE ; Enable Timer1 interrupt
	bcf		STATUS,RP0	; select memory bank 0
	bcf 	PIR1,TMR1IF ; clear timer interrupt flag
	bsf		INTCON,PEIE	; enable peripheral interrupts
	bsf		INTCON,GIE	; enable interrupts


READ
; read on and off flags
	btfsc	OFF_FLAG,0	; off flag
	goto	OFF			; drive OFF relay
	btfsc	ON_FLAG,0	; on Flag
	goto	ON			; drive ON relay

; read switches
; set drive lines low
	clrf	PORTA
	bcf		PORTB,0	

; check if switch delay flag is set
	btfsc	SW_DLY,0
	call	SW_DELY	
; read RB5, RB4, RB2
	btfss	PORTB,5
	goto	SWITCH_PRESSED
	btfss	PORTB,4
	goto	SWITCH_PRESSED
	btfsc	PORTB,2
	goto	DISPLAY


SWITCH_PRESSED

	bcf		DISP_CHNG,0	; clear display change flag

; check switches on RB0
	movf	PORTA,w
	iorlw	B'00011100'
	movwf	PORTA		; RA2, RA3 and RA4 high	
	btfss	PORTB,4		; if low then switch S1 closed
	goto	S1
; check switches on RA2
	bsf		PORTB,0		; RB0 high
	movf	PORTA,w
	iorlw	B'00011000'	; set RA3 and RA4 high
	andlw	B'11111011'	; set RA2 low
	movwf	PORTA		; RA2 low RA3 and RA4 high	
	btfss	PORTB,5		; if low then switch OFF switch closed
	goto	OFF
	btfss	PORTB,4		; if low then switch S2 closed
	goto	S2
	btfss	PORTB,2		; if low then SET switch
	goto	SET_SW
; check switches on RA3

	movf	PORTA,w
	iorlw	B'00010100'	; RA2 and RA4 high
	andlw	B'11110111'	; set RA2 low
	movwf	PORTA		; RA2, RA3 and RA4 high/low	
	btfss	PORTB,5		; if low then switch LAMP switch closed
	goto	LAMP
	btfss	PORTB,4		; if low then switch S4 closed
	goto	S4
	btfss	PORTB,2		; if low then CYCLE switch
	goto	CYCLE
; check switches on RA4

	movf	PORTA,w
	iorlw	B'00001100'	; RA2 and RA3 high
	andlw	B'11101111'	; set RA4 low
	movwf	PORTA		; RA2, RA3 and RA4 high/low	
	btfss	PORTB,5		; if low then switch ON switch closed
	goto	ON
	btfss	PORTB,4		; if low then switch S3 closed
	goto	S3
	btfss	PORTB,2		; if low then NEXT switch
	goto	NEXT_SW
	goto	DISPLAY		; no switch

S2; hours down
; check if set or start mode and next display setting

	btfsc	SET_START,0	; clear is set mode
	goto	DISPLAY
	btfsc	CYCLE_MODE,0	; 00 is count down mode, 01 is real clock time mode 
	goto	RTC_HR_DN
	btfsc	NEXT,0		; clear is top line setting
	goto	LOW_LINE_DN_HRS

; option to stop count down from 0
; Top line down
; HR_ON_IN	; hour on in counter
;	movf	HR_ON_IN,w
;	btfss	STATUS,Z	; if zero no decrementing
	decf	HR_ON_IN,f	; next hours
	call	SW_DELAY
	goto	DISPLAY
LOW_LINE_DN_HRS
; option to stop count down from 0
; HR_OFF_IN	; hour off in counter
;	movf	HR_OFF_IN,w
;	btfss	STATUS,Z	; if zero no decrementing
	decf	HR_OFF_IN,f	; next hours
	call	SW_DELAY
	goto	DISPLAY

RTC_HR_DN
	btfsc	NEXT,1		; if set it is the CLOCK
	goto	CLOCK_HR_DN
	btfsc	NEXT,0		; clear is top line setting
	goto	LOW_LINE_DN_HRS_RTC
; Top line down
; HR_ON_AT	; hour on at counter
	movf	HR_ON_AT,w
	btfss	STATUS,Z	; if zero no decrementing
	decf	HR_ON_AT,f	; next hours
	call	SW_DELAY
	goto	DISPLAY
LOW_LINE_DN_HRS_RTC
; HR_OFF_AT	; hour off at counter
	movf	HR_OFF_AT,w
	btfss	STATUS,Z	; if zero no decrementing
	decf	HR_OFF_AT,f	; next hours
	call	SW_DELAY
	goto	DISPLAY
CLOCK_HR_DN
; bypass hours when ppm setting
	btfsc	NEXT,0		; clear is top line setting
	goto	CLOCK_HR_DN_RTC
; correction ppm

	btfss	CORRECTION,7
	goto	DOWN_1		; allow decrement when clear
	comf	CORRECTION,w
	addlw	D'1'
	sublw	D'98'			; set limits
	btfsc	STATUS,C
DOWN_1
	decf	CORRECTION,f
	goto	CORR_WRI

CLOCK_HR_DN_RTC
; HOURS	; hours for clock
	bcf		STATUS,GIE		; stop interrupt
	movf	HOURS,w
	btfss	STATUS,Z	; if zero no decrementing
	decf	HOURS,f		; next hours
	clrf	SECONDS_RTC
	bsf		STATUS,GIE		; allow interrupt
	call	SW_DELAY
	goto	DISPLAY

S1; hours up

; check if set or start mode and next display setting

	btfsc	SET_START,0	; clear is set mode
	goto	DISPLAY
	btfsc	CYCLE_MODE,0	; 00 is count down mode, 01 is real clock time mode 
	goto	RTC_HR_UP
	btfsc	NEXT,0		; clear is top line setting
	goto	LOW_LINE_UP_HRS
; Top line up
; HR_ON_IN	; hour on in counter
	incf	HR_ON_IN,f		; next hours

; option for a lower limit
; check for 99 hours
;	movf	HR_ON_IN,w
;	sublw	D'99'
;	movlw	D'99'
;	btfss	STATUS,C 	; 99 hours 
;	movwf	HR_ON_IN
	call	SW_DELAY
	goto	DISPLAY
LOW_LINE_UP_HRS
; HR_OFF_IN	; hour off in counter
	incf	HR_OFF_IN,f		; next hours

; option for a lower limit
; check for 99 hours
;	movf	HR_OFF_IN,w
;	sublw	D'99'
;	movlw	D'99'
;	btfss	STATUS,C 	; 99 hours 
;	movwf	HR_OFF_IN
	call	SW_DELAY
	goto	DISPLAY

RTC_HR_UP
	btfsc	NEXT,1		; if set it is the CLOCK
	goto	CLOCK_HR_UP
	btfsc	NEXT,0		; clear is top line setting
	goto	LOW_LINE_UP_HRS_RTC
; Top line up
; HR_ON_AT	; hour on at counter
	incf	HR_ON_AT,f		; next hours

; check for 23 hours
	movf	HR_ON_AT,w
	sublw	D'23'
	movlw	D'23'
	btfss	STATUS,C 	; 23 hours 
	movwf	HR_ON_AT
	call	SW_DELAY
	goto	DISPLAY
LOW_LINE_UP_HRS_RTC
; HR_OFF_AT	; hour off at counter
	incf	HR_OFF_AT,f		; next hours

; check for 23 hours
	movf	HR_OFF_AT,w
	sublw	D'23'
	movlw	D'23'
	btfss	STATUS,C 	; 23 hours 
	movwf	HR_OFF_AT
	call	SW_DELAY
	goto	DISPLAY

CLOCK_HR_UP

	btfsc	NEXT,0		; clear is RTC setting
	goto	CLOCK_HR_UP_RTC
; correction ppm

	btfsc	CORRECTION,7
	goto	UP_HR			; allow increase when minus
	movf	CORRECTION,w
	sublw	D'98'		; limit to +99
	btfsc	STATUS,C
UP_HR
	incf	CORRECTION,f

; write to EEPROM
	goto	CORR_WRI

CLOCK_HR_UP_RTC

; bypass hours when ppm setting
	btfss	NEXT,0		; RTC setting
	goto	DISPLAY
; HOURS	; timer hours
	bcf		STATUS,GIE		; stop interrupt
	incf	HOURS,f		; next hours

; check for 23 hours
	movf	HOURS,w
	sublw	D'23'
	movlw	D'23'
	btfss	STATUS,C 	; 23 hours 
	movwf	HOURS
	clrf	SECONDS_RTC
	bsf		STATUS,GIE		; allow interrupt
	call	SW_DELAY
	goto	DISPLAY

S4; Minutes down
; check if set or start mode and next display setting

	btfsc	SET_START,0	; clear is set mode
	goto	DISPLAY
	btfsc	CYCLE_MODE,0	; 00 is count down mode, 01 is real clock time mode 
	goto	RTC_MIN_DN
	btfsc	NEXT,0		; 
	goto	LOW_LINE_DN_MINS
; Top line down
; MIN_ON_IN	; Minutes on in counter
	movf	MIN_ON_IN,w
	btfss	STATUS,Z
	decf	MIN_ON_IN,f		; next minutes
	call	SW_DELAY
	goto	DISPLAY
LOW_LINE_DN_MINS
;	MIN_OFF_IN	; minutes off in counter
	movf	MIN_OFF_IN,w
	btfss	STATUS,Z
	decf	MIN_OFF_IN,f		; next minutes
	call	SW_DELAY
	goto	DISPLAY

RTC_MIN_DN
	btfsc	NEXT,1
	goto	CLOCK_MIN_DN
	btfsc	NEXT,0		; RTC setting
	goto	LOW_LINE_DN_MINS_RTC

; Top line down
; MIN_ON_AT	; Minutes on in counter
	movf	MIN_ON_AT,w
	btfss	STATUS,Z
	decf	MIN_ON_AT,f		; next minutes
	call	SW_DELAY
	goto	DISPLAY
LOW_LINE_DN_MINS_RTC
; MIN_OFF_AT	; minutes off at counter
	movf	MIN_OFF_AT,w
	btfss	STATUS,Z
	decf	MIN_OFF_AT,f		; next minutes
	call	SW_DELAY
	goto	DISPLAY
CLOCK_MIN_DN
	btfsc	NEXT,0		; clear is top line setting
	goto	CLOCK_MIN_DN_RTC
; correction ppm

DEC_CORR
	btfss	CORRECTION,7
	goto	DOWN		; allow decrement when clear
	comf	CORRECTION,w
	addlw	D'1'
	sublw	D'98'			; set limits
	btfsc	STATUS,C
DOWN
	decf	CORRECTION,f

; write to EEPROM
CORR_WRI
	movlw	EEPROM1
	call	EEREAD
	movf	CORRECTION,w
	call	EEWRITE
	call	SW_DELAY
	goto	DISPLAY

CLOCK_MIN_DN_RTC

; MINUTES	; clock minutes
	bcf		STATUS,GIE		; stop interrupt
	movf	MINUTES,w
	btfss	STATUS,Z
	decf	MINUTES,f		; next minutes
	clrf	SECONDS_RTC
	bsf		STATUS,GIE		; allow interrupt
	call	SW_DELAY
	goto	DISPLAY

S3; Minutes up

; check if set or start mode and next display setting

	btfsc	SET_START,0	; clear is set mode
	goto	DISPLAY
	btfsc	CYCLE_MODE,0	; 00 is count down mode, 01 is real clock time mode 
	goto	RTC_MIN_UP
	btfsc	NEXT,0		; clear is top line setting
	goto	LOW_LINE_UP_MINS
; Top line up
; MIN_ON_IN	; Minutes on in counter
	incf	MIN_ON_IN,f		; next minutes

; check for 59 minutes
	movf	MIN_ON_IN,w
	sublw	D'59'
	movlw	D'59'
	btfss	STATUS,C 	; 59 minutes 
	movwf	MIN_ON_IN
	call	SW_DELAY
	goto	DISPLAY
LOW_LINE_UP_MINS
; MIN_OFF_IN	; minutes off in counter
	incf	MIN_OFF_IN,f		; next minutes

; check for 59 minutes
	movf	MIN_OFF_IN,w
	sublw	D'59'
	movlw	D'59'
	btfss	STATUS,C 	; 59 minutes 
	movwf	MIN_OFF_IN
	call	SW_DELAY
	goto	DISPLAY

RTC_MIN_UP
	btfsc	NEXT,1		; if set it is the CLOCK
	goto	CLOCK_MIN_UP
	btfsc	NEXT,0		; clear is top line setting
	goto	LOW_LINE_UP_MINS_RTC
; Top line up
; MIN_ON_AT	; Minutes on in counter
	incf	MIN_ON_AT,f		; next minutes

; check for 59 minutes
	movf	MIN_ON_AT,w
	sublw	D'59'
	movlw	D'59'
	btfss	STATUS,C 	; 59 minutes 
	movwf	MIN_ON_AT
	call	SW_DELAY
	goto	DISPLAY
LOW_LINE_UP_MINS_RTC
; MIN_OFF_AT	; minutes off at counter
	incf	MIN_OFF_AT,f		; next minutes

; check for 59 minutes
	movf	MIN_OFF_AT,w
	sublw	D'59'
	movlw	D'59'
	btfss	STATUS,C 	; 59 minutes 
	movwf	MIN_OFF_AT
	call	SW_DELAY
	goto	DISPLAY

CLOCK_MIN_UP

	btfsc	NEXT,0		; RTC setting
	goto	CLOCK_MIN_UP_RTC
; correction ppm

	btfsc	CORRECTION,7
	goto	UP			; allow increase when minus
	movf	CORRECTION,w
	sublw	D'98'		; limit to +99
	btfsc	STATUS,C
UP	incf	CORRECTION,f

; write to EEPROM
	goto	CORR_WRI

CLOCK_MIN_UP_RTC
; MINUTES	; clock minutes
	bcf		STATUS,GIE		; stop interrupt
	incf	MINUTES,f		; next minutes

; check for 59 minutes
	movf	MINUTES,w
	sublw	D'59'
	movlw	D'59'
	btfss	STATUS,C 	; 59 minutes 
	movwf	MINUTES
	clrf	SECONDS_RTC
	bsf		STATUS,GIE		; allow interrupt
	call	SW_DELAY
	goto	DISPLAY

ON; send a power on signal

	clrf	ON_FLAG		; on flag
	bsf		PORTB,6
	movlw	H'80'		; address line 1 
	call	LOAD
	call	SPACE4
	call	SPACE4
	call	SPACE4
	call	SPACE2
	movlw	A'O'		; 
	call	DRV_LCD
	movlw	A'N'		; 
	call	DRV_LCD

	movlw	D'70'		; 900ms pulse
	call	SW_DELAY1
	bcf		PORTB,6
	bcf		DISP_CHNG,0	; clear display change flag
; store last on or off signal
	movlw	B'00000001'	; 01 is on
	movwf	LAST
	goto	DISPLAY

OFF; send a power off signal
	clrf	OFF_FLAG	; off flag
	bsf		PORTB,1
	movlw	H'C0'		; address line 2 
	call	LOAD
	call	SPACE4
	call	SPACE4
	call	SPACE4
	call	SPACE1
	movlw	A'O'		; 
	call	DRV_LCD
	movlw	A'F'		; 
	call	DRV_LCD
	movlw	A'F'		; 
	call	DRV_LCD	
	
	movlw	D'70'		; 900ms pulse
	call	SW_DELAY1
	bcf		PORTB,1
	bcf		DISP_CHNG,0	; clear display change flag
; store last on or off signal
	movlw	B'00000010'	; 10 is off
	movwf	LAST
	goto	DISPLAY

SET_SW; set or start
	incf	SET_START,f	; alternate between set and start
; when set, clear SECONDS in mode 0
	btfss	SET_START,0
	goto	SET_SW1
	btfss	CYCLE_MODE,0	; 00 is count down mode, 01 is real clock time mode
	clrf	SECONDS 
SET_SW1
; store ON_IN and OFF_IN values
	movf	MIN_ON_IN,w
	movwf	MIN_ON_IN_STORE
	movf	HR_ON_IN,w
	movwf	HR_ON_IN_STORE
	movf	MIN_OFF_IN,w
	movwf	MIN_OFF_IN_STORE
	movf	HR_OFF_IN,w
	movwf	HR_OFF_IN_STORE
	
	call	SW_DELY
	bcf		DISP_CHNG,0	; clear display change flag
	goto	DISPLAY

NEXT_SW; next display
	btfsc	CYCLE_MODE,0		; when zero just toggle bit 0
	goto 	RTC_ROTATE
	incf	NEXT,w
	andlw	B'00000001'
	movwf	NEXT
	call	SW_DELY
	bcf		DISP_CHNG,0	; clear display change flag
	goto	DISPLAY	

RTC_ROTATE
	btfss	SET_START,0	; when in start mode, rotate bit 1 for clock shown on each alternate Next press
	goto	SET_ROTATE
	incf	NEXT,f
	incf	NEXT,f
	bcf		NEXT,0
	goto	OUT_NEXT

SET_ROTATE
	incf	NEXT,f		; next display for setting
OUT_NEXT
	call	SW_DELY
	bcf		DISP_CHNG,0	; clear display change flag
	goto	DISPLAY

CYCLE; run through Modes

; display current mode
; CYCLE_MODE (EEPROM4) bit 0 clear=ON/OFF IN, 
; IN_SELECT (EEPROM2) bit 0 clear=ONCE, bit 0 set= REPEAT
; CYCLE_MODE (EEPROM4) bit 0 set=ON/OFF AT
; AT_SELECT (EEPROM3) bit 0 clear=REPEAT, bit 0 set=ONCE

; check cycle mode

	movlw	D'10'
	movwf	CYC_DEL		; cycle counter

	btfsc	CYCLE_MODE,0
	goto	MODE_AT	


	movlw	H'80'		; address line 1 
	call	LOAD

	movlw	A'O'		; 
	call	DRV_LCD
	movlw	A'N'		; 
	call	DRV_LCD
	movlw	A'/'		; 
	call	DRV_LCD
	movlw	A'O'		; 
	call	DRV_LCD
	movlw	A'F'		; 
	call	DRV_LCD
	movlw	A'F'		; 
	call	DRV_LCD
	movlw	A'-'		; 
	call	DRV_LCD
	movlw	A'I'		; 
	call	DRV_LCD
	movlw	A'N'		; 
	call	DRV_LCD
	call	SPACE2
	movlw	A'h'		; 
	call	DRV_LCD
	movlw	A'h'		; 
	call	DRV_LCD
	movlw	A':'		; 
	call	DRV_LCD
	movlw	A'm'		; 
	call	DRV_LCD
	movlw	A'm'		; 
	call	DRV_LCD

	movlw	H'C0'		; address line 2 
	call	LOAD
	btfss	IN_SELECT,0	; set = repeat, clear = clear
	goto	IN_AT_CLEAR
IN_AT_REPEAT
	movlw	A'R'		; 
	call	DRV_LCD
	movlw	A'E'		; 
	call	DRV_LCD
	movlw	A'P'		; 
	call	DRV_LCD
	movlw	A'E'		; 
	call	DRV_LCD
	movlw	A'A'		; 
	call	DRV_LCD
	movlw	A'T'		; 
	call	DRV_LCD
	call	SPACE4
	call	SPACE4
	call	SPACE2
	goto	COUNTDOWN
IN_AT_CLEAR
	movlw	A'O'		; 
	call	DRV_LCD
	movlw	A'N'		; 
	call	DRV_LCD
	movlw	A'C'		; 
	call	DRV_LCD
	movlw	A'E'		; 
	call	DRV_LCD
	call	SPACE1
	movlw	A'O'		; 
	call	DRV_LCD
	movlw	A'N'		; 
	call	DRV_LCD
	movlw	A'L'		; 
	call	DRV_LCD
	movlw	A'Y'		; 
	call	DRV_LCD
	call	SPACE4
	call	SPACE4
	goto	COUNTDOWN

MODE_AT	

	movlw	H'80'		; address line 1 
	call	LOAD

	movlw	A'O'		; 
	call	DRV_LCD
	movlw	A'N'		; 
	call	DRV_LCD
	movlw	A'/'		; 
	call	DRV_LCD
	movlw	A'O'		; 
	call	DRV_LCD
	movlw	A'F'		; 
	call	DRV_LCD
	movlw	A'F'		; 
	call	DRV_LCD
	movlw	A'-'		; 
	call	DRV_LCD
	movlw	A'A'		; 
	call	DRV_LCD
	movlw	A'T'		; 
	call	DRV_LCD
	call	SPACE2
	movlw	A'h'		; 
	call	DRV_LCD
	movlw	A'h'		; 
	call	DRV_LCD
	movlw	A':'		; 
	call	DRV_LCD
	movlw	A'm'		; 
	call	DRV_LCD
	movlw	A'm'		; 
	call	DRV_LCD

	movlw	H'C0'		; address line 2 
	call	LOAD
	btfsc	AT_SELECT,0	; clear = restore value, set = clear
	goto	IN_AT_CLEAR
	goto	IN_AT_REPEAT
; cycle switch needs to be held for x seconds
; display timout
COUNTDOWN
TEST_CYCLE_SW
	movlw	D'40'
	call	SW_DELAY1 
	btfsc	PORTB,2			; if low then CYCLE switch
	goto	CYCLE_OUT
	movlw	H'CD'			; address line 2 pos D
	call	LOAD
	movlw	H'4'			; cycle symbol 2
	btfss	ROTATE,3
	movlw	H'3'			; cycle symbol 1
	incf	ROTATE,f
	call	DRV_LCD
	movf	CYC_DEL,w		; cycle counter
	call	TWO_DIGITS_0	; leading 0 blanking

; to check cycle switch set up switch drivers
	bsf		PORTB,0
	movf	PORTA,w
	iorlw	B'00010100'	; RA2 and RA4 high
	andlw	B'11110111'	; set RA2 low
	movwf	PORTA		; RA2, RA3 and RA4 high/low	

	decfsz	CYC_DEL,f
	goto 	TEST_CYCLE_SW
CK_MODES
	clrf	ROTATE		; cycle symbol change rate counter
; check modes and change to next selection
; if CYCLE_MODE,0 is clear check IN_SELECT,0
	btfss	CYCLE_MODE,0
	goto	CK_IN_SEL
; check AT_SELECT
	btfsc	AT_SELECT,0	; if set change cycle mode and clear IN_SELECT
	goto	MODE0
	incf	AT_SELECT,f	; change setting
	goto	WRITE_MODES	
MODE0 ; CYCLE_MODE and IN_SELECT clear
	clrf	CYCLE_MODE
	clrf	IN_SELECT
	clrf	AT_SELECT
	goto	WRITE_MODES	
CK_IN_SEL
	btfsc	IN_SELECT,0	; if set change cycle mode and clear IN_SELECT
	goto	MODE1
	incf	IN_SELECT,f	; change setting
	goto	WRITE_MODES
MODE1
	incf	CYCLE_MODE,f
	clrf	IN_SELECT
; get value
WRITE_MODES

	movlw	EEPROM2		; On and Off IN goes to 0 or return to last setting so cycle repeats (ON pressed at power up to toggle selection)
	call	EEREAD
	movf	IN_SELECT,w
	call	EEWRITE		; store

	movlw	EEPROM3		; On and Off AT daily or once only (OFF pressed at power up to toggle selection)
	call	EEREAD
	movf	AT_SELECT,w
	call	EEWRITE		; store

; cycle mode store
	movlw	EEPROM4		; ON/OFF IN or ON/OF AT cycle
	call	EEREAD
	movf	CYCLE_MODE,w
	call	EEWRITE

	clrf	NEXT
CYCLE_OUT
	call	SW_DELY
	goto	READ		; read switches

LAMP; lamp brightness in LCD
	
	btfss	UP_DN,0			; down counting
	goto	DOWN_BRIGHT
	incf	BRIGHTNESS,f
	movlw	B'11110000'
	andwf	BRIGHTNESS,w		; if not zero then load 15
	btfsc	STATUS,Z
	goto	CK_WRIT
	movlw	D'15'
	movwf	BRIGHTNESS			; reload at full brightness
	bcf		UP_DN,0
	goto	CK_WRIT	

DOWN_BRIGHT
	decfsz	BRIGHTNESS,f
	goto	CK_WRIT
; when zero change to increment
	bsf		UP_DN,0			; up counting	

CK_WRIT
	btfsc	BACK,0
	goto	BACK_VALUE
	bsf		BACK,0
	movlw	H'80'			; address line 1 pos 0
	call	LOAD
	call	BACK_LIGHTING	; write BACK LIGHTING
	goto	POSITION_BY
BACK_VALUE
	movlw	H'8E'			; address line 1 pos E
	call	LOAD
POSITION_BY

	movlw	EEPROM5		; backlighting brightness
	call	EEREAD
	movf	BRIGHTNESS,w
	call	EEWRITE		; store
; display value	
	movf	BRIGHTNESS,w
	movwf	CCPR1L			; place in PWM
	movwf	ROLL
	call	TWO_DIGITS_0	; leading 0 blanking
	movlw	H'C0'			; address line 2 pos 0
	call	LOAD
	incf	ROLL,f

LOOP_ROLL
	movlw	H'00' 			; brightness block for bargraph
	call	DRV_LCD			; place character 
	decfsz	ROLL,f
	goto	LOOP_ROLL
	
CLR_LINE	
; clear second line
	movf	CCPR1L,w
	sublw	D'17'
	movwf	REPEAT
	
SP1	call	SPACE1
	decfsz	REPEAT,f
	goto	SP1

	movlw	D'50'
	call	SW_DELAY1

; check if lamp switch is closed. maintain dimming direction if switch held closed

	btfss	PORTB,5		; if low then switch LAMP switch closed
	goto	LAMP

; if brightness is zero or 15 do not alter direction
; change dimming direction if switch is opened
	movf	BRIGHTNESS,w
	btfsc	STATUS,Z
	goto 	READ
	xorlw	D'15'
	btfss	STATUS,Z
	incf	UP_DN,f			; change up/down counting direction

	goto	READ


DISPLAY

; check if under backup power (only 1/256 counts)
	decfsz	POWER_TEST,f ; check every 256 counts
	goto	REWR
; RA0 monitors main power input
	bcf		STATUS,GIE
; set PORTA,0 low
	bcf		PORTA,0
; set PORTA,0 as an input

	bsf		STATUS,RP0	; select memory bank 1
	bsf		TRISA,0
	bcf		STATUS,RP0	; select memory bank 0

; check if power at RA0
	nop
	btfss	PORTA,0
	goto	BACK_OFF
; restore PWM drive to backlight LEDs
	movf	BRIGHTNESS,w
	movwf	CCPR1L
; if there was a blackout, return previous on or off setting
	btfss	BLACKOUT,0
	goto	REWR

; allow a startup delay for mains switch with power up
	movlw	D'255'
	call	SW_DELAY1
	
	clrf	BLACKOUT	; blackout flag off
	bsf		STATUS,GIE
; send last on/off
	btfsc	LAST,0	; if set then ON signal
	goto	ON
	btfsc	LAST,1	; if set then an off signal
	goto	OFF
	goto	RA_OUT			
BACK_OFF ; backlight off in a blackout
; backlight off
	clrf	CCPR1L
	bsf		BLACKOUT,0		; blackout flag on
; set PORTA,0 as an output
RA_OUT
	bcf		STATUS,GIE
	bsf		STATUS,RP0	; select memory bank 1
	bcf		TRISA,0
	bcf		STATUS,RP0	; select memory bank 0
	bsf		STATUS,GIE

; display on screen according to Mode
; rewrite time displays
REWR
	bcf		BACK,0		; back lighting written flag

; colon flash

CK_COLON
	btfss	SET_START,0
	goto	DISPLAY_CHANGE
	btfss	COLON_FLASH,1	; if set colon flash both lines
	goto	X_COLON1		; 1 line
	movlw	H'8A'		; address line 1 pos for colon
	call	LOAD
; alternate between : and space (blank)
	btfsc	COLON_FLASH,0; colon
	goto	X_FLASH_COLON
	movlw	A':'		; 
	call	DRV_LCD
	goto	X_COLON1
X_FLASH_COLON
	call	SPACE1

X_COLON1
	movlw	H'CA'		; address line 2 pos for colon
	call	LOAD
	btfsc	COLON_FLASH,0
	goto	X_FLASH_COLON2
	movlw	A':'		; 
	call	DRV_LCD
	goto	CLOCK_TEST
X_FLASH_COLON2
	call	SPACE1

CLOCK_TEST
; if clock display show second colon
	btfss	CYCLE_MODE,0
	goto	DISPLAY_CHANGE
	btfss	NEXT,1
	goto	DISPLAY_CHANGE
	movlw	H'CD'		; address line 2 pos for colon
	call	LOAD
	btfsc	COLON_FLASH,0
	goto	X_FLASH_COLON_SEC
	movlw	A':'		; 
	call	DRV_LCD
	goto	DISPLAY_CHANGE
X_FLASH_COLON_SEC
	call	SPACE1

DISPLAY_CHANGE
	btfsc	DISP_CHNG,0	; when clear update display
	goto	READ
	bsf		DISP_CHNG,0	; set display change flag
MODE_A
; check mode
	btfsc	CYCLE_MODE,0	; 00 is count down mode, 01 is real clock time mode 
	goto	REAL_T_DSP
; timers
; write ON IN HH MM
	movlw	H'80'		; address line 1 pos 0
	call	LOAD
	call 	SPACE1
	movlw	A'O'		; 
	call	DRV_LCD
	movlw	A'N'		; 
	call	DRV_LCD
	call	SPACE1
	movlw	A'I'		; 
	call	DRV_LCD
	movlw	A'N'		; 
	call	DRV_LCD
; check if set or start mode and next display setting

	btfsc	SET_START,0	; clear is set mode
	goto	ON_IN_SPACE
	btfsc	NEXT,0		; clear is ON_IN setting
	goto	ON_IN_SPACE
	movlw	A'"'		; 
	call	DRV_LCD
	goto	ON_IN_0

ON_IN_SPACE
	call	SPACE1

; HR_ON_IN	; hour on in counter
; MIN_ON_IN	; minutes on in counter

; counters check for zero

ON_IN_0
	movf	HR_ON_IN,w	; hour on-in counter
	btfss	STATUS,Z
	goto	ON_IN_SHOW
	movf	MIN_ON_IN,w	; minutes on-in counter
	btfsc	STATUS,Z
	goto	ON_IN_DASH	; show dashes when both are 0
ON_IN_SHOW
	movf	HR_ON_IN,w
	call	THREE_DIGITS
	movlw	A':'		; add colon
	call	DRV_LCD
	movf	MIN_ON_IN,w
	call	TWO_DIGITS

	goto	WRI_ON_IN_SET_START
ON_IN_DASH	; show dashes when both are 0
	movlw	A'-'		; 
	call	DRV_LCD
	movlw	A'-'		; 
	call	DRV_LCD
	movlw	A'-'		; 
	call	DRV_LCD
	movlw	A':'		; 
	call	DRV_LCD
	movlw	A'-'		; 
	call	DRV_LCD
	movlw	A'-'		; 
	call	DRV_LCD

; check if set or start mode and next display setting
WRI_ON_IN_SET_START
	btfsc	SET_START,0	; clear is set mode
	goto	ON_IN_SPACE_A
	btfsc	NEXT,0		; clear is ON_IN setting
	goto	ON_IN_SPACE_A
	movlw	A'"'		; 
	call	DRV_LCD
	call 	SPACE3
	goto	WRI_OFF_IN1
ON_IN_SPACE_A
	call 	SPACE4
; write OFF IN HH MM
WRI_OFF_IN1	
	movlw	H'C0'		; address line 2 pos 0
	call	LOAD
	movlw	A'O'		; 
	call	DRV_LCD
	movlw	A'F'		; 
	call	DRV_LCD
	movlw	A'F'		; 
	call	DRV_LCD
	call	SPACE1
	movlw	A'I'		; 
	call	DRV_LCD
	movlw	A'N'		; 
	call	DRV_LCD

; check if set or start mode and next display setting

	btfsc	SET_START,0	; clear is set mode
	goto	OFF_IN_SPACE
	btfss	NEXT,0		; clear is ON_IN setting
	goto	OFF_IN_SPACE
	movlw	A'"'		; 
	call	DRV_LCD
	goto	OFF_IN_0

OFF_IN_SPACE
	call	SPACE1

; HR_OFF_IN	; hour off in counter
; MIN_OFF_IN	; minutes off in counter

OFF_IN_0
	movf	HR_OFF_IN,w	; hour off-in counter
	btfss	STATUS,Z
	goto	OFF_IN_SHOW
	movf	MIN_OFF_IN,w	; minutes off-in counter
	btfsc	STATUS,Z
	goto	OFF_IN_DASH	; show dashes when both are 0
OFF_IN_SHOW
	movf	HR_OFF_IN,w
	call	THREE_DIGITS
	movlw	A':'		; add colon
	call	DRV_LCD
	movf	MIN_OFF_IN,w
	call	TWO_DIGITS
	goto	WRI_OFF_IN_SET_START
OFF_IN_DASH	; show dashes when both are 0
	movlw	A'-'		; 
	call	DRV_LCD
	movlw	A'-'		; 
	call	DRV_LCD
	movlw	A'-'		; 
	call	DRV_LCD
	movlw	A':'		; 
	call	DRV_LCD
	movlw	A'-'		; 
	call	DRV_LCD
	movlw	A'-'		; 
	call	DRV_LCD

; check if set or start mode and next display setting
WRI_OFF_IN_SET_START
	btfsc	SET_START,0	; clear is set mode
	goto	OFF_IN_SPACE_A
	btfss	NEXT,0		; clear is ON_IN setting
	goto	OFF_IN_SPACE_A
	movlw	A'"'		; 
	call	DRV_LCD
	call 	SPACE3
	goto	READ
OFF_IN_SPACE_A
	call 	SPACE4
	goto	READ

REAL_T_DSP
; scroll display with NEXT value
	
	movf	NEXT,w
	btfsc	STATUS,Z
	goto	DISP1
	btfsc	NEXT,1
	goto	DISP2
	
DISP1
	call	ON_AT_HHMM
	call	OFF_AT_HHMM
	goto	READ
DISP2
	call	RTC_SHOW
	goto	READ

; Real Time Clock

; write CLOCK

RTC_SHOW

; Line 1
	movlw	H'80'		; address line 1 pos 0
	call	LOAD
; check if set or start mode and next display setting
	btfsc	SET_START,0	; clear is set mode
	goto	START_RUN
	movlw	A'A'		; 
	call	DRV_LCD
	movlw	A'D'		; 
	call	DRV_LCD
	movlw	A'J'		; 
	call	DRV_LCD
	movlw	A'U'		; 
	call	DRV_LCD
	movlw	A'S'		; 
	call	DRV_LCD
	movlw	A'T'		; 
	call	DRV_LCD

	btfsc	NEXT,0		; 
	goto	BY_PPM

	movlw	D'2'		; right pointer -
	call	DRV_LCD	
	movlw	D'1'		; right pointer >
	call	DRV_LCD
	call	SPACE1
	goto	VALUE
BY_PPM
	call	SPACE3
	goto	VALUE
START_RUN
	call	SPACE4
	call	SPACE4
	call	SPACE1
VALUE
; no ppm display in run mode
	btfsc	SET_START,0	; clear is set mode
	goto	NO_PPM_SHOW
	movf	CORRECTION,w	; ppm value
	xorlw	H'0'
	btfsc	STATUS,Z
	goto	ZERO		; no sign when 0	
	btfsc	CORRECTION,7
	goto	MINUS
	movlw	A'+'		; 
	call	DRV_LCD	
	goto	CONT_COR
MINUS
	movlw	A'-'		; 
	call	DRV_LCD	
	goto	CONT_COR
ZERO
	call	SPACE1	
CONT_COR
	comf	CORRECTION,w
	addlw	D'1'
	btfss	CORRECTION,7	; if set use com value +1 bypassing  movf	CORRECTION,w
	movf	CORRECTION,w
	call	TWO_DIGITS_0
	call	SPACE1
SKIP_SP
	movlw	A'p'		; 
	call	DRV_LCD
	movlw	A'p'		; 
	call	DRV_LCD
	movlw	A'm'		; 
	call	DRV_LCD
	call 	SPACE4
	goto	CLOCK_LINE
NO_PPM_SHOW
	call 	SPACE3
	call	SPACE4

CLOCK_LINE
	movlw	H'C0'		; address line 2 pos 0
	call	LOAD
	movlw	A'C'		; 
	call	DRV_LCD
	movlw	A'L'		; 
	call	DRV_LCD
	movlw	A'O'		; 
	call	DRV_LCD
	movlw	A'C'		; 
	call	DRV_LCD	
	movlw	A'K'		; 
	call	DRV_LCD
	btfsc	SET_START,0	; clear is set mode
	goto	START_RUN2
	btfss	NEXT,0		; 
	goto	START_RUN2
	movlw	D'2'		; right pointer -
	call	DRV_LCD
	movlw	D'1'		; right pointer >
	call	DRV_LCD
	call	SPACE1
	goto	HRS1
START_RUN2
	call	SPACE3
HRS1
	movf	HOURS,w
	call	TWO_DIGITS_0
; if set clock display show colon
	btfsc	SET_START,0	; clear is set mode
	goto	COLON_MISS1
	movlw	A':'
	call	DRV_LCD	
	goto	BY_1
COLON_MISS1
	call 	SPACE1
BY_1
	movf	MINUTES,w
	call	TWO_DIGITS
; if set clock display show colon
	btfsc	SET_START,0	; clear is set mode
	goto	COLON_MISS2
	movlw	A':'
	call	DRV_LCD	
	goto	BY_2
COLON_MISS2
	call 	SPACE1
BY_2

	movf	SECONDS_RTC,w
	call	TWO_DIGITS
	call 	SPACE2
	return

RTC_TIMERS
; RTC timers

; ******************
; write 
ON_AT_HHMM
	movlw	H'80'		; address line 1 pos 0
	call	LOAD
	call 	SPACE1
	movlw	A'O'		; 
	call	DRV_LCD
	movlw	A'N'		; 
	call	DRV_LCD
	call	SPACE1
	movlw	A'A'		; 
	call	DRV_LCD
	movlw	A'T'		; 
	call	DRV_LCD
	call	SPACE1
; check if set or start mode and next display setting

	btfsc	SET_START,0	; clear is set mode
	goto	ON_AT_SPACE
	btfsc	NEXT,0		; clear is ON_AT setting
	goto	ON_AT_SPACE
	movlw	A'"'		; 
	call	DRV_LCD
	goto	ON_AT_0

ON_AT_SPACE
	call	SPACE1

;	HR_ON_AT	; hour on at counter
;	MIN_ON_AT	; minutes on at counter

; counters check for zero

ON_AT_0
	movf	HR_ON_AT,w	; hour on-at counter
	btfss	STATUS,Z
	goto	ON_AT_SHOW
	movf	MIN_ON_AT,w	; minutes on-at counter
	btfsc	STATUS,Z
	goto	ON_AT_DASH	; show dashes when both are 0
ON_AT_SHOW
	movf	HR_ON_AT,w
	call	TWO_DIGITS_0
	movlw	A':'		; add colon
	call	DRV_LCD
	movf	MIN_ON_AT,w
	call	TWO_DIGITS

	goto	WRI_ON_AT_SET_START
ON_AT_DASH	; show dashes when both are 0
	movlw	A'-'		; 
	call	DRV_LCD
	movlw	A'-'		; 
	call	DRV_LCD
	movlw	A':'		; 
	call	DRV_LCD
	movlw	A'-'		; 
	call	DRV_LCD
	movlw	A'-'		; 
	call	DRV_LCD

; check if set or start mode and next display setting
WRI_ON_AT_SET_START
	btfsc	SET_START,0	; clear is set mode
	goto	ON_AT_SPACE_A
	btfsc	NEXT,0		; clear is ON_AT setting
	goto	ON_AT_SPACE_A
	movlw	A'"'		; 
	call	DRV_LCD
	call 	SPACE3
	return
ON_AT_SPACE_A
	call 	SPACE4
	return
; ***************************
; write 
OFF_AT_HHMM
	
	movlw	H'C0'		; address line 2 pos 0
	call	LOAD
	movlw	A'O'		; 
	call	DRV_LCD
	movlw	A'F'		; 
	call	DRV_LCD
	movlw	A'F'		; 
	call	DRV_LCD
	call	SPACE1
	movlw	A'A'		; 
	call	DRV_LCD
	movlw	A'T'		; 
	call	DRV_LCD
	call	SPACE1
; check if set or start mode and next display setting

	btfsc	SET_START,0	; clear is set mode
	goto	OFF_AT_SPACE
	btfss	NEXT,0		; clear is ON_IN setting
	goto	OFF_AT_SPACE
	movlw	A'"'		; 
	call	DRV_LCD
	goto	OFF_AT_0

OFF_AT_SPACE
	call	SPACE1

;	HR_OFF_AT	; hour off at counter
;	MIN_OFF_AT	; minutes off at counter

OFF_AT_0
	movf	HR_OFF_AT,w	; hour off-at counter
	btfss	STATUS,Z
	goto	OFF_AT_SHOW
	movf	MIN_OFF_AT,w	; minutes off-at counter
	btfsc	STATUS,Z
	goto	OFF_AT_DASH	; show dashes when both are 0
OFF_AT_SHOW
	movf	HR_OFF_AT,w
	call	TWO_DIGITS_0
	movlw	A':'		; add colon
	call	DRV_LCD
	movf	MIN_OFF_AT,w
	call	TWO_DIGITS

	goto	WRI_OFF_AT_SET_START
OFF_AT_DASH	; show dashes when both are 0
	movlw	A'-'		; 
	call	DRV_LCD
	movlw	A'-'		; 
	call	DRV_LCD
	movlw	A':'		; 
	call	DRV_LCD
	movlw	A'-'		; 
	call	DRV_LCD
	movlw	A'-'		; 
	call	DRV_LCD

; check if set or start mode and next display setting
WRI_OFF_AT_SET_START
	btfsc	SET_START,0	; clear is set mode
	goto	OFF_AT_SPACE_A
	btfss	NEXT,0		; clear is ON_IN setting
	goto	OFF_AT_SPACE_A
	movlw	A'"'		; 
	call	DRV_LCD
	call 	SPACE3
	return
OFF_AT_SPACE_A
	call 	SPACE4
	return

; xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx

; Subroutines

; display routines

BACK_LIGHTING; write BACK LIGHTING
	movlw	A'B'		; 
	call	DRV_LCD
	movlw	A'a'		; 
	call	DRV_LCD
	movlw	A'c'		; 
	call	DRV_LCD
	movlw	A'k'		; 
	call	DRV_LCD
	call	SPACE1
	movlw	A'L'		; 
	call	DRV_LCD
	movlw	A'i'		; 
	call	DRV_LCD
	movlw	A'g'		; 
	call	DRV_LCD
	movlw	A'h'		; 
	call	DRV_LCD
	movlw	A't'		; 
	call	DRV_LCD
	movlw	A'i'		; 
	call	DRV_LCD
	movlw	A'n'		; 
	call	DRV_LCD
	movlw	A'g'		; 
	call	DRV_LCD
	call	SPACE1
	return


TWO_DIGITS_0; drives display with 2-digits zero suppression
	movwf	BIN_0		; binary value
	call	BCD_ASCII	; get bcd/ASCII value
	movf	OUT2,w		; ms value
	xorlw	H'30'		; check if 0
	btfss	STATUS,Z
	goto	LOAD11
	call	SPACE1		; leading 0 to space
	goto	SPACE22	
LOAD11
	movf	OUT2,w
	call	DRV_LCD
SPACE22
	movf	OUT3,w
	call	DRV_LCD
	return

TWO_DIGITS; drives display with 2-digits
	movwf	BIN_0		; binary value
	call	BCD_ASCII	; get bcd/ASCII value
	movf	OUT2,w		; ms value
	movf	OUT2,w
	call	DRV_LCD
	movf	OUT3,w
	call	DRV_LCD
	return

THREE_DIGITS; drives display with 3-digits
	movwf	BIN_0		; binary value

	call	BCD_ASCII	; get bcd/ASCII value
	movf	OUT1,w		; ms value
	xorlw	H'30'		; check if 0
	btfss	STATUS,Z
	goto	LOAD1
	call	SPACE1		; leading 0's to space
	movf	OUT2,w
	xorlw	H'30'		; is it zero
	btfss	STATUS,Z
	goto	LOAD2
	call	SPACE1		; leading 0's to space
	goto	LOAD3
LOAD1
	movf	OUT1,w
	call	DRV_LCD
LOAD2
	movf	OUT2,w
	call	DRV_LCD
LOAD3
	movf	OUT3,w
	call	DRV_LCD
	return

; add space/spaces in display

SPACE4
	movlw	H'20'		; space
	call	DRV_LCD
SPACE3
	movlw	H'20'		; space
	call	DRV_LCD
SPACE2
	movlw	H'20'		; space
	call	DRV_LCD
SPACE1
	movlw	H'20'		; space
	call	DRV_LCD
	return

; switch delay sets switch delay flag
SW_DELAY
	bsf		SW_DLY,0
	return
SW_DELY
	bcf		SW_DLY,0	 
	movlw	D'20'
SW_DELAY1 
	movwf	SW_FLAG
SW_LOOP
	call	DELAYms
	decfsz	SW_FLAG,f	; decrease til zero
	goto	SW_LOOP
	return

; delay loop 

DELAYms
	movlw	D'23'		; delay value
DELAYX
	movwf	STORE1		; STORE1 is number of loops value
LOOP8	
	movlw	H'B0' 
DELDSP
	movwf	STORE2		; STORE2 is internal loop value	
LOOP9
	decfsz	STORE2,f
	goto	LOOP9
	decfsz	STORE1,f
	goto	LOOP8
	return

DELAY1 ;
	movlw	D'2'		; delay value
DELAYXX
	movwf	STORE1		; STORE1 is number of loops value
LOOPA	
	movlw	D'165'
	movwf	STORE2		; STORE2 is internal loop value	
LOOPB
	decfsz	STORE2,f
	goto	LOOPB
	decfsz	STORE1,f
	goto	LOOPA		; decrease till STORE1 is zero
	return



; preload display commands (4-bit) 
LOAD
	movwf	D_STO		; store data	
	movf	D_STO,w
	andlw	H'F0'		; get upper bits
; place ms bits of display commands in portA/B
	movwf	LCD_STO
	clrf	PORTA		; data lines low
	bcf		PORTB,0	
	btfsc	LCD_STO,7
	bsf		PORTB,0		; set data lines if required
	btfsc	LCD_STO,6
	bsf		PORTA,2	
	btfsc	LCD_STO,5
	bsf		PORTA,3	
	btfsc	LCD_STO,4
	bsf		PORTA,4	
	nop
	bcf		PORTB,7		; register select low
	nop
	bsf		PORTA,1		; enable set
	nop
	bcf		PORTA,1		; enable clear
	call	BUS_CK

	swapf	D_STO,w
	andlw	H'F0'		; get lower bits

; place ls 4-bits display commands in portA
	movwf	LCD_STO
	clrf	PORTA
	bcf		PORTB,0	
	btfsc	LCD_STO,7
	bsf		PORTB,0		; set data lines if required
	btfsc	LCD_STO,6
	bsf		PORTA,2	
	btfsc	LCD_STO,5
	bsf		PORTA,3	
	btfsc	LCD_STO,4
	bsf		PORTA,4	
	nop
	bcf		PORTB,7		; register select low
	nop
	bsf		PORTA,1		; enable set
	nop
	bcf		PORTA,1		; enable clear
	goto	BUS_CK		; check busy flag


; driving the LCD module with display data

DRV_LCD;	
	movwf	D_STO		; store data
	andlw	H'F0'		; upper bits
	movwf	LCD_STO
	clrf	PORTA
	bcf		PORTB,0	
	btfsc	LCD_STO,7
	bsf		PORTB,0		; set data lines if required
	btfsc	LCD_STO,6
	bsf		PORTA,2	
	btfsc	LCD_STO,5
	bsf		PORTA,3	
	btfsc	LCD_STO,4
	bsf		PORTA,4	
	nop
	bsf		PORTB,7		; register select
	nop
	bsf		PORTA,1		; enable high
	nop
	bcf		PORTA,1		; enable low
	call	BUS_CK

	swapf	D_STO,w
	andlw	H'F0'		; lower bits
	movwf	LCD_STO
	clrf	PORTA
	bcf		PORTB,0	
	btfsc	LCD_STO,7
	bsf		PORTB,0		; set data lines if required
	btfsc	LCD_STO,6
	bsf		PORTA,2	
	btfsc	LCD_STO,5
	bsf		PORTA,3	
	btfsc	LCD_STO,4
	bsf		PORTA,4	
	nop
	bsf		PORTB,7		; register select
	nop
	bsf		PORTA,1		; enable high
	nop
	bcf		PORTA,1		; enable low

BUS_CK ; time for display to finish updating data 
	movlw 	D'2'		; 
	movwf	STORE1		; delay values
	movlw	D'255'		;  delay for busy flag to clear
	goto	DELDSP


; Subroutine to convert from 8-bit binary to 2-digit BCD (packed)
; Binary value is in BIN_0  
; Result in BCD is in BCD_0 & BCD_1.  
; BCD_0 is MSB, BCD_1 is LSB
; converts to unpacked ASCII in OUT1, OUT2, OUT3 (out1 is ms byte, out3 is ls byte)

BCD_ASCII
	bcf		STATUS,C	; clear carry bit
	movlw	D'8'
	movwf	CNT_8		; 8 in count
	clrf	BCD_0
	clrf	BCD_1		; set BCD registers to 0 
LOOPBCD
	rlf		BIN_0,f		; shift left binary registers
	rlf		BCD_1,f		; MSB shift left
	rlf		BCD_0,f		; LSB shift left BCD registers
	decfsz	CNT_8,f		; reduce count value return when 0
	goto	DECADJ		; continue decimal adjust

; completed decimal to BCD operation, convert to unpacked ASCII
	
	movf	BCD_1,w		; ls decimal
	andlw	H'0F'		; ls
	addlw	H'30'		; convert to ASCII
	movwf	OUT3
	swapf	BCD_1,w 	; mid decimal value
	andlw	H'0F'
	addlw	H'30'		; convert to ASCII
	movwf	OUT2
	movf	BCD_0,w
	addlw	H'30'		; convert to ASCII
	movwf	OUT1		; ms decimal value
	return				; ASCII values returned in OUT1, OUT2, OUT3 

; subroutine decimal adjust

DECADJ
	movlw	BCD_1		; BCD LSB address
	movwf	FSR			; pointer for BCD1
	call	ADJBCD		; subroutine to adjust BCD
	movlw	BCD_0		; BCD MS address
	movwf	FSR			; pointer for BCD0
	call	ADJBCD
	goto	LOOPBCD

; subroutine adjust BCD

ADJBCD	
	movlw	H'03'		; w has 03 
	addwf	INDF,w		; add 03 to BCDx register (x is 0-1)
	movwf	TEMP		; store w
	btfsc	TEMP,3		; test if >7
	movwf	INDF		; save as LS digit
	movlw	H'30'		; 3 for MSbyte
	addwf	INDF,w		; add 30 to BCDx register
	movwf	TEMP		; store w in temp
	btfsc	TEMP,7		; test if >7
	movwf	INDF		; save as MS digit
	return				; end subroutine

; character generation 	
CHARACTR_GEN

; character 1. Partial block 5 x 6 for a bargraph
	movlw	B'01000000'	; address 0
	call	LOAD		; character gen 1 
	movlw	B'00000000'
	call	DRV_LCD
	movlw	B'00000000'
	call	DRV_LCD
	movlw	B'00011111'
	call	DRV_LCD
	movlw	B'00011111'
	call	DRV_LCD
	movlw	B'00011111'
	call	DRV_LCD
	movlw	B'00011111'
	call	DRV_LCD
	movlw	B'00011111'
	call	DRV_LCD
	movlw	B'00011111'
	call	DRV_LCD

; character 2. -> Partial right arrow
	movlw	B'00001000'
	call	DRV_LCD
	movlw	B'00000100'
	call	DRV_LCD
	movlw	B'00000010'
	call	DRV_LCD
	movlw	B'00011111'
	call	DRV_LCD
	movlw	B'00011111'
	call	DRV_LCD
	movlw	B'00000010'
	call	DRV_LCD
	movlw	B'00000100'
	call	DRV_LCD
	movlw	B'00001000'
	call	DRV_LCD

; character 3. - Remainder of right arrow
	movlw	B'00000000'
	call	DRV_LCD
	movlw	B'00000000'
	call	DRV_LCD
	movlw	B'00000000'
	call	DRV_LCD
	movlw	B'00000111'
	call	DRV_LCD
	movlw	B'00000111'
	call	DRV_LCD
	movlw	B'00000000'
	call	DRV_LCD
	movlw	B'00000000'
	call	DRV_LCD
	movlw	B'00000000'
	call	DRV_LCD

; character 4. CYCLE 1 symbol
	movlw	B'00000100'
	call	DRV_LCD
	movlw	B'00000110'
	call	DRV_LCD
	movlw	B'00001111'
	call	DRV_LCD
	movlw	B'00010110'
	call	DRV_LCD
	movlw	B'00010100'
	call	DRV_LCD
	movlw	B'00010001'
	call	DRV_LCD
	movlw	B'00010001'
	call	DRV_LCD
	movlw	B'00001110'
	call	DRV_LCD

; character 5. rotated CYCLE 2 symbol
	movlw	B'00001110'
	call	DRV_LCD
	movlw	B'00010001'
	call	DRV_LCD
	movlw	B'00010001'
	call	DRV_LCD
	movlw	B'00000101'
	call	DRV_LCD
	movlw	B'00001101'
	call	DRV_LCD
	movlw	B'00011110'
	call	DRV_LCD
	movlw	B'00001100'
	call	DRV_LCD
	movlw	B'00000100'
	call	DRV_LCD
	return

; subroutine to read EEPROM memory 

EEREAD
	bcf		STATUS,RP1	; select bank 0
	bsf 	STATUS,RP1	; select memory bank 2
	movwf 	EEADR		; indirect special function register
	bsf 	STATUS,RP0	; select memory bank 3
	bcf		EECON1,EEPGD; data memory
	bsf		EECON1,RD	; read EEPROM
	bcf 	STATUS,RP0	; select memory bank 2
	movf	EEDATA,w	; EEPROM value in w
	bcf		STATUS,RP1	; select bank 0
	return

; subroutine to write to EEPROM
EWRITE
EEWRITE	
	bcf 	STATUS,RP0	; bank 0
	bsf		STATUS,RP1	; select bank 2
	movwf	EEDATA		; data register
	bsf 	STATUS,RP0	; select memory bank 3
WR3	
	btfsc	EECON1,WR	; check if write complete 
	goto 	WR3			; not written yet
	bcf		INTCON,GIE	; disable interrupts
	bcf		EECON1,EEPGD; data memory
	bsf		EECON1,WREN	; enable write
	movlw	H'55'		; place 55H in w for write sequence
	movwf 	EECON2 		; write 55H to EECON2
	movlw 	H'AA'		; AAH to w
	movwf	EECON2		; write AA to EECON2
	bsf		EECON1,WR	; set WR bit and begin write sequence
	bcf		EECON1,WREN	; clear WREN bit
	bsf 	INTCON,GIE	; enable interrupts
WRITE
	btfsc	EECON1,WR	; skip if write complete 
	goto 	WRITE		; not written yet
	bcf		EECON1,EEIF	; clear write interrupt flag
	bcf		STATUS,RP1	; 
	bcf 	STATUS,RP0	; select memory bank 0
	return				; value written 
; *************************************************

INTERRUPT

; start interrupt by saving w and status registers 
	movwf	W_TMP		; w to w_tmp storage
	swapf	STATUS,w	; status to w
	movwf	STATUS_TMP	; status in status_tmp 
	bcf		STATUS,RP0	; select memory bank 0
	bcf		STATUS,RP1	; select memory bank 0

; update clock 
	btfss	PIR1,TMR1IF
	goto	END_INTERRUPT
	bcf 	PIR1,TMR1IF ; clear timer interrupt flag

; PPM correction for timing tolerance correction for the crystal
; timer1 counts 1 million every second so a 1 change is 1ppm
; TMR1 counts the 1MHz clock 40000 times before interrupt than repeated 25 times to give 1 second
; adjust in parts per million (ppm). A TMR1L change by 1 in 40000 once every 25 gives 1ppm change.
; so use CORRECTION ppm value to add or subtract from H'C1', the 0ppm setting for a 4MHz crystal
; CORRECTION. Bit 7 set = -ppm, clear= +ppm. The + value will speed up the clock
; +1 to +99= 0 to D'99'
; -1 to -99 = H'FF' to H'9D'

; D40000 (H9C40) counts so preload FFFF-9C40=H63BF 
; compensate for stopping clock by several cycles = H'C6' for TMR1L
; change on a count of 10 for MSECS. That is once in a count of 25
; 25 interrupts per second

	movf	MSECS,w
	xorlw	D'10'			; when D'10' use ppm correction
	movlw	H'C6'			; use H'C6' for 0ppm change for TMR1L normally that's 24times in 25
	btfss	STATUS,Z
	goto	ADD_TMR1L
; count of 10. The once in 25 change
	btfsc	CORRECTION,7	; check for - or plus
	goto	SEVEN_SET
 	movf	CORRECTION,w
	addlw	H'C6'			; value  from a 4MHz crystal
	btfsc	STATUS,C		; if over change MSB
	incf	TMR1H,f
	goto	ADD_TMR1L
SEVEN_SET ; values with bit 7 set for -
	comf	CORRECTION,w
	addlw	D'1'
	sublw	H'C6'
ADD_TMR1L
	bcf		T1CON,0 	; timer1 off	
	addwf	TMR1L,f
	btfsc	STATUS,C	; if over change MSB
	incf	TMR1H,f
	movlw	H'63'
	addwf	TMR1H,f
	bsf		T1CON,0 	; timer1 on	
	incf	MSECS,f
; check for 25 
	movf	MSECS,w
	sublw	D'25'		; 25 for 1s 
	btfsc	STATUS,Z 	; 
	clrf	MSECS		; clear milliseconds

; compare with 6 and 19
	movf	MSECS,w
	btfsc	STATUS,Z
	goto	TIMERS_RUN
; colon flashing
	movf	MSECS,w
	xorlw	D'6'
	btfsc	STATUS,Z
	goto	RUN_COLON
	movf	MSECS,w
	xorlw	D'19'
	btfss	STATUS,Z
	goto	END_INTERRUPT
	
RUN_COLON
	btfsc	BACK,0			; if backlight display no flashing colon
	goto	END_INTERRUPT
; if clock display flash colon
	btfss	MODE,1
	goto	CK_STRT
	btfss	NEXT,1
	goto	CK_STRT
	bcf		COLON_FLASH,1; bottom line only
	goto	COLON1
CK_STRT

	btfss	SET_START,0	; clear is set mode
	goto	TIMERS_RUN

	bsf		COLON_FLASH,1; both lines

COLON1
	btfss	MSECS,0
	goto	FLASH_COLON2
	bsf		COLON_FLASH,0; colon
	goto	TIMERS_RUN
FLASH_COLON2
	bcf		COLON_FLASH,0; space

TIMERS_RUN
	movf	MSECS,w
	btfss	STATUS,Z
	goto	END_INTERRUPT
; seconds
	incf	SECONDS,f	; seconds

; check for 60s 
	movf	SECONDS,w
	sublw	D'60'		; 60s 
	btfss	STATUS,Z 	; 
	goto	SEC_RTC		; not 60s
	clrf	SECONDS		; clear seconds

; seconds RTC
SEC_RTC
	incf	SECONDS_RTC,f	; seconds

; if clock displayed clear display flag so seconds will be displayed
	btfsc	NEXT,1
	clrf	DISP_CHNG

; check for 60s 
	movf	SECONDS_RTC,w
	sublw	D'60'		; 60s 
	btfsc	STATUS,Z 	; 
	clrf	SECONDS_RTC	; clear seconds

; minutes

; RTC run clock

; MINUTES		; minutes RTC
; HOURS			; hours RTC
	movf	SECONDS_RTC,w	; check if RTC seconds are clear
	btfss	STATUS,Z
	goto	CK_SET_STRT
	incf	MINUTES,f 	; next minutes
	bcf		DISP_CHNG,0	; clear display change flag
; check for 60 minutes
	movf	MINUTES,w
	sublw	D'60'
	btfss	STATUS,Z 	; 60 minutes
	goto	CK_SET_STRT		; not 60mins
	clrf	MINUTES		; clear minutes
	incf	HOURS,f		; next hours

; check for 24 hours
	movf	HOURS,w
	sublw	D'24'
	btfsc	STATUS,Z 	; 24 hours 
	clrf	HOURS


; check if set or start
CK_SET_STRT
	btfss	SET_START,0	; if clear then set mode
	goto	END_INTERRUPT
; check mode
	btfsc	CYCLE_MODE,0	; 00 is count down mode, 01 is real clock time mode 
	goto	COMPARE_ON

; check timer seconds
	movf	SECONDS,w	; check if seconds are clear
	btfss	STATUS,Z
	goto	END_INTERRUPT

; Count down timers
;	HR_ON_IN	; hour on in counter
;	MIN_ON_IN	; minutes on in counter

; On-in counters check for zero
ON_IN
	movf	HR_ON_IN,w	; hour on-in counter
	btfss	STATUS,Z
	goto	DEC_ON_IN
	movf	MIN_ON_IN,w	; minutes on-in counter
	btfsc	STATUS,Z
	goto	OFF_IN	; bypass decreasing counters when both are 0
DEC_ON_IN
; decrease to 0
	movlw	D'01'
	subwf	MIN_ON_IN,f; minutes on-in counter
	btfsc	STATUS,Z
	goto	CK_HR_ON_IN
	btfsc	STATUS,C
	goto	OFF_IN
; check hours for zero. 
	movf	HR_ON_IN,w
	btfsc	STATUS,Z
	goto	BOTH_0_ON_IN
	goto	HR_DOWN_IN

CK_HR_ON_IN
; check hours for zero. 
	movf	HR_ON_IN,w
	btfss	STATUS,Z
	goto	OFF_IN
; both zero so set OFF_FLAG	
BOTH_0_ON_IN
	clrf	MIN_ON_IN	; minutes on-in counter
	bsf		ON_FLAG,0

; if IN_SELECT,0 is set then restore ON_IN value
	btfss	IN_SELECT,0
	goto	OFF_IN
; but only restore if the OFF_IN counters are both zero. Then restore both ON and OFF IN
; check OFF_IN
	movf	HR_OFF_IN,w	; hour off-in counter
	btfss	STATUS,Z
	goto	OFF_IN
	movf	MIN_OFF_IN,w; minutes off-in counter
	btfss	STATUS,Z
	goto	OFF_IN

	movf	MIN_ON_IN_STORE,w
	movwf	MIN_ON_IN
	movf	HR_ON_IN_STORE,w
	movwf	HR_ON_IN

	movf	MIN_OFF_IN_STORE,w
	movwf	MIN_OFF_IN
	movf	HR_OFF_IN_STORE,w
	movwf	HR_OFF_IN
	goto	END_INTERRUPT

HR_DOWN_IN
; set minutes at 59 and decrease hours
	movlw	D'59'
	movwf	MIN_ON_IN
	decf	HR_ON_IN,f
	
; HR_OFF_IN	 ; hour off in counter
; MIN_OFF_IN ; minues off in counter
; Off-in counters check for zero
OFF_IN
	movf	HR_OFF_IN,w	; hour off-in counter
	btfss	STATUS,Z
	goto	DEC_OFF_IN
	movf	MIN_OFF_IN,w; minutes off-in counter
	btfsc	STATUS,Z
	goto	END_INTERRUPT	; bypass decreasing counters when both are 0

DEC_OFF_IN
; decrease to 0
	movlw	D'01'
	subwf	MIN_OFF_IN,f; minutes off-in counter
	btfsc	STATUS,Z
	goto	CK_HR_OFF_IN
	btfsc	STATUS,C
	goto	END_INTERRUPT
; check hours for zero. 
	movf	HR_OFF_IN,w
	btfsc	STATUS,Z
	goto	BOTH_0_OFF_IN
	goto	HR_DOWN_IN1

CK_HR_OFF_IN
; check hours for zero. 
	movf	HR_OFF_IN,w
	btfss	STATUS,Z
	goto	END_INTERRUPT
BOTH_0_OFF_IN
; both zero so set OFF_FLAG	
	clrf	MIN_OFF_IN	; minutes off-in counter
	bsf		OFF_FLAG,0

; if IN_SELECT,0 is set then restore OFF_IN value
	btfss	IN_SELECT,0
	goto	END_INTERRUPT
; but only restore if the ON_IN counters are both zero. Then restore both ON and OFF IN
; check ON_IN
	movf	HR_ON_IN,w	; hour on-in counter
	btfss	STATUS,Z
	goto	END_INTERRUPT
	movf	MIN_ON_IN,w; minutes on-in counter
	btfss	STATUS,Z
	goto	END_INTERRUPT

	movf	MIN_ON_IN_STORE,w
	movwf	MIN_ON_IN
	movf	HR_ON_IN_STORE,w
	movwf	HR_ON_IN

	movf	MIN_OFF_IN_STORE,w
	movwf	MIN_OFF_IN
	movf	HR_OFF_IN_STORE,w
	movwf	HR_OFF_IN
	goto	END_INTERRUPT

HR_DOWN_IN1
; set minutes at 59 and decrease hours
	movlw	D'59'
	movwf	MIN_OFF_IN
	decf	HR_OFF_IN,f	
	goto	END_INTERRUPT

; comparison counters
; HR_ON_AT	; hour on at counter
; MIN_ON_AT	; minutes on in counter
; HR_OFF_AT	; hour off at counter
; MIN_ON_AT	; minutes on in counter

COMPARE_ON ; time with RTC

; if hours and minutes are both zero bypass comparison
	movf	HOURS,w
	btfss	STATUS,Z	; when equal check minutes
	goto	COMP		; see comment re fixing location
	movf	MINUTES,w
	btfsc	STATUS,Z	; when equal
	goto	END_INTERRUPT

; check timer seconds
COMP; (fixed location for this as it was at location compx previously and so missing the seconds check when hours were >1)
.
	movf	SECONDS_RTC,w	; check if seconds are clear
	btfss	STATUS,Z
	goto	END_INTERRUPT
compx
	movf	HOURS,w
	subwf	HR_ON_AT,w
	btfss	STATUS,Z	; when equal check minutes
	goto	COMPARE_OFF

	movf	MINUTES,w
	subwf	MIN_ON_AT,w
	btfss	STATUS,Z	; when equal set on flag
	goto	COMPARE_OFF
	bsf		ON_FLAG,0

; check AT_SELECT,0. when set clear HR_ON_AT and MIN_ON_AT

	btfss	AT_SELECT,0
	goto	COMPARE_OFF
	clrf	HR_ON_AT
	clrf	MIN_ON_AT

COMPARE_OFF ; time with RTC

	movf	HOURS,w
	subwf	HR_OFF_AT,w
	btfss	STATUS,Z	; when equal check minutes
	goto	END_INTERRUPT

	movf	MINUTES,w
	subwf	MIN_OFF_AT,w
	btfss	STATUS,Z	; when equal set on flag
	goto	END_INTERRUPT
	bsf		OFF_FLAG,0

; check AT_SELECT,0. when set clear HR_OFF_AT and MIN_OFF_AT

	btfss	AT_SELECT,0
	goto	END_INTERRUPT
	clrf	HR_OFF_AT
	clrf	MIN_OFF_AT

END_INTERRUPT

	swapf	STATUS_TMP,w; status temp storage to w
	movwf	STATUS		; w to status register
	swapf	W_TMP,f		; swap upper and lower 4-bits in w_tmp
	swapf   W_TMP,w		; swap bits and into w register
	retfie				; return from interrupt

	end
